package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.model.EmployeeOrgRoleHistory;
@Component
public class EmpOrgRoleHistoryConverter {
	
	public static EmployeeOrgRoleHistoryDTO convert(EmployeeOrgRoleHistory org){
		
		EmployeeOrgRoleHistoryDTO orgDTO = new EmployeeOrgRoleHistoryDTO();
		orgDTO.setOplock(org.getOplock());
		orgDTO.setId(org.getId());
		orgDTO.setEmployeeOrgRoleDTO(OrgRoleConverter.convert(org.getEmployeeOrgRole()));
		orgDTO.setModificationDate(org.getModificationDate());
		orgDTO.setRoleAction(org.getRoleAction());
		orgDTO.setPerformingEmployee(EmployeeConverter.convert(org.getPerformingEmployee()));
		return orgDTO;
	}
	
	public List<EmployeeOrgRoleHistoryDTO> convert(List<EmployeeOrgRoleHistory> source) {
    	
    	List<EmployeeOrgRoleHistoryDTO> destination = new ArrayList<EmployeeOrgRoleHistoryDTO>();
    	for(EmployeeOrgRoleHistory a : source) {
			destination.add(convert(a));
		}
		return destination;
	}
    
}
